<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Db_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->common_model->__session();
    }

    public function select($data, $table, $where = "1=1")
    {
        $this->db->select($data)->from($table)->where($where)->order_by('id', 'DESC')->limit(1);
        $result = $this->db->get()->row();

        return $result->$data;
    }

    function select_all($table, $data)
    {
        return $this->db->select($data)->from($table)->get()->result();
    }

    public function select_multi($data, $table, $where = "1=1")
    {
        $this->db->select($data)->from($table)->where($where)->order_by('id', 'DESC')->limit(1);
        $result = $this->db->get()->row();

        return $result;
    }

    public function update($data, $table, $where = "1=1")
    {
        $this->db->where($where);
        $this->db->update($table, $data);
    }

    public function count_all($table, $where = "1=1")
    {
        $this->db->from($table);
        $this->db->where($where);

        return $this->db->count_all_results();
    }

    public function sum($data, $table, $where = "1=1")
    {
        $this->db->select_sum($data);
        $this->db->where($where);
        $this->db->from($table);

        $result = $this->db->get()->row();

        return $result->$data;
    }

    function total_downline_autopool($key, $value, $field, $table, $autopool = 0, &$visited = [])
    {
        $downline = [];

        // Prevent infinite loops
        if (in_array($value, $visited)) {
            return [];
        }
        $visited[] = $value;

        $this->db->select("$field as field, autopool")
            ->from($table)
            ->where($key, $value);

        $results = $this->db->get()->result();

        foreach ($results as $row) {

            if ($autopool > 0) {
                if ($row->autopool >= $autopool) {
                    $downline[] = $row->field;
                }
            } else {
                $downline[] = $row->field;
            }

            // Recursive call WITHOUT overwriting $value
            $childDownline = $this->total_downline_autopool(
                $key,
                $row->field,
                $field,
                $table,
                $autopool,
                $visited
            );

            $downline = array_merge($downline, $childDownline);
        }

        // Remove duplicates
        return array_values(array_unique($downline));
    }

    function upload_image($path, $name)
    {
        $config['upload_path']          = './uploads/' . $path;
        $config['allowed_types']        = 'jpg|png|jpeg';
        // $config['max_size']             = 100;
        // $config['max_width']            = 1024;
        // $config['max_height']           = 768;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload($name)) {
            $upload_data =  $this->upload->data();
            $image_path = "uploads/" . $path . '/' . $upload_data['file_name'];
            $val = array('text' => $image_path, 'icon' => 1);
        } else {
            $val = array('text' => $this->upload->display_errors(), 'icon' => 0);
        }
        return $val;
    }
}
