<?php

defined('BASEPATH') or exit('No direct script access allowed');

class CorePlan_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->common_model->__session();
    }


    function collect_fund($userid)
    {
        $autopool_fund = $this->db_model->select('balance', 'fund', ['id' => 1]);
        $autopool_fund_amount = 300;
        $data = [
            'balance' => $autopool_fund + $autopool_fund_amount
        ];
        $this->db->where('id', 1)->update('fund', $data);
        $data = [
            'fund_id' => 1,
            'userid' => $userid,
            'amount' => $autopool_fund_amount,
            'status' => 'In',
            'remark' => 'autopool Fund Credited',
        ];
        $this->db->insert('fund_record', $data);



        $council_board_fund = $this->db_model->select('balance', 'fund', ['id' => 2]);
        $council_board_fund_amount = 100;
        $data = [
            'balance' => $council_board_fund + $council_board_fund_amount
        ];
        $this->db->where('id', 2)->update('fund', $data);
        $data = [
            'fund_id' => 2,
            'userid' => $userid,
            'amount' => $council_board_fund_amount,
            'status' => 'In',
            'remark' => 'council Board Fund Credited',
        ];
        $this->db->insert('fund_record', $data);


        $champion_board_fund = $this->db_model->select('balance', 'fund', ['id' => 3]);
        $champion_board_fund_amount = 100;
        $data = [
            'balance' => $champion_board_fund + $champion_board_fund_amount
        ];
        $this->db->where('id', 3)->update('fund', $data);
        $data = [
            'fund_id' => 3,
            'userid' => $userid,
            'amount' => $champion_board_fund_amount,
            'status' => 'In',
            'remark' => 'Champion Board Fund Credited',
        ];
        $this->db->insert('fund_record', $data);



        $leader_board_fund = $this->db_model->select('balance', 'fund', ['id' => 4]);
        $leader_board_fund_amount = 50;
        $data = [
            'balance' => $leader_board_fund + $leader_board_fund_amount
        ];
        $this->db->where('id', 4)->update('fund', $data);
        $data = [
            'fund_id' => 4,
            'userid' => $userid,
            'amount' => $leader_board_fund_amount,
            'status' => 'In',
            'remark' => 'Leader Board Fund Credited',
        ];
        $this->db->insert('fund_record', $data);




        return true;
    }



    function approve_now($id)
    {
        $donation = $this->db_model->select_multi('*', 'donar_receiver_record', array('id' => $id));
        if ($donation->status == 'Pending') {
            $sponsor = $this->db_model->select('sponsor', 'member', array('id' => $donation->donar_id));
            $this->db->where('id', $id)->update('donar_receiver_record', array('status' => 'Approved'));
            $rank = $this->db_model->select('rank_name', 'rank_system', array('id' => 1));

            $product = $this->db_model->select_multi('id,prod_price', 'product', ['id' => $donation->product_id]);
            $data = array(
                'topup' => $product->prod_price,
                'rank_id' => 1,
                'rank' => $rank,
                'signup_package' => $donation->product_id,
                'topup_date' => date('Y-m-d H:i:s')
            );

            $this->db->where('id', $donation->donar_id)->update('member', $data);
            if ($sponsor > 0 && $sponsor != '') {
                $sponsor = $sponsor;
                $this->upgrade_rank_and_make_elig_to_get_income($sponsor);
            } else {
                $sponsor = config_item('top_id');
            }
        }
        return true;
    }

    function upgrade_rank_and_make_elig_to_get_income($userid)
    {
        $flag = 1;
        $rank_id = 0;
        $rank_id = $this->db_model->select('rank_id', 'member', array('id' => $userid));

        $count_sponsor_rank_member = $this->check_memeber_rank_with_level($userid, $rank_id);

        $flag = 0;
        $new_rank_id = 0;
        if ($count_sponsor_rank_member >= 2) {

            $flag = 1;
            $new_rank_id = $rank_id + 1;
            $rank = $this->db_model->select('rank_name', 'rank_system', array('id' => $new_rank_id));
            $this->db->where('id', $userid)->update('member', array('live_status' => 0, 'rank_id' => $new_rank_id, 'rank' => $rank));
            $data = [
                'userid' => $userid,
                'rank' => $rank,
                'rank_id' => $new_rank_id,
            ];
            $this->db->insert('rank_log', $data);
        }

        $sponsor = $this->db_model->select('sponsor', 'member', array('id' => $userid));
        $sponsor_det = $this->db_model->select_multi('*', 'member', array('id' => $sponsor));

        $upline = $this->find_upline($userid, $new_rank_id);

        // give income to this upline


        if ($new_rank_id >= 2 && $flag == 1 && $upline > 0) {
            $count_downline_rank_member = $this->check_memeber_rank_with_level($upline, $new_rank_id);

            $income_list = array(
                // 'rank'=>'Income' income/member not upgrading amount   
                2 => 4000,
                3 => 8000,
                4 => 16000,
                5 => 32000,
                6 => 64000,
                7 => 128000,
                8 => 256000,

            );


            $income = $income_list[$new_rank_id];

            $array = array(
                'userid' => $upline,
                'amount' => $income,
                'without_tax_amt' => $income,
                'tax' => $userid . '-' . $rank,
                'tid' => $userid,
                'date' => date('Y-m-d'),
            );

            if ($count_downline_rank_member > 2) {
                $reciever_wallet_balance = $this->db_model->select('balance', 'wallet', ['userid' => $upline]);
                $new_balance = $reciever_wallet_balance + $income;
                $this->db->where('userid', $upline)->update('wallet', ['balance' => $new_balance]);

                $data = [
                    'userid' => $upline,
                    'amount' => $income,
                    'status' => 'CR',
                    'remark' => $userid . '-' . $rank,
                    'date' => date('Y-m-d H:i:s')
                ];


                $this->db->insert('wallet_transection_report', $data);

                $data = [
                    'userid' => $upline,
                    'amount' => $income,
                    'status' => 'Paid',
                    'type' =>  $userid . '-' . $rank,
                    'ref_id' => '',
                    'secret' => 4,
                    'date' => date('Y-m-d H:i:s')
                ];

                $this->db->insert('earning', $data);
            }
        } elseif ($new_rank_id >= 2 && $upline > 0) {

            $income_list = array(
                // 'rank'=>'Income' income/member not upgrading amount   
                2 => 4000,
                3 => 8000,
                4 => 16000,
                5 => 32000,
                6 => 64000,
                7 => 128000,
                8 => 256000,
            );


            $income = $income_list[$new_rank_id];

            $array = array(
                'userid' => $upline,
                'amount' => $income,
                'without_tax_amt' => $income,
                'tax' => $userid . '-' . $rank,
                'tid' => $userid,
                'date' => date('Y-m-d'),
            );



            // $this->db->insert('withdraw_request', $array);
        }


        if ($sponsor > 0) {
            return $this->upgrade_rank_and_make_elig_to_get_income($sponsor);
        } else {
            return false;
        }
    }

    function check_memeber_rank_with_level($userid, $level)
    {
        $downline = $this->db->select('downline')->from('level_wise_list')->where('userid', $userid)->where('level', $level)->get()->result();
        // echo $this->db->last_query()."<br>";
        $totalvaid_mem = 0;
        foreach ($downline as $d) {
            $rank_id = 0;
            $rank_id = $this->db_model->select('rank_id', 'member', array('id' => $d->downline));
            if ($level <= $rank_id) {
                $totalvaid_mem++;
            }
        }

        return $totalvaid_mem;
    }

    function find_upline($userid, $rank_id, $up = 1)
    {
        $position = $this->db_model->select('position', 'member', array('id' => $userid));

        $upline = $this->db_model->select_multi('*', 'member', array('id' => $position));

        if ($rank_id <= $up && $upline->topup > 0 && $upline->rank_id >= $rank_id) {
            return $upline->id;
        } elseif ($upline->id <= 0 || $upline->id == '') {
            return 0;
        } else {
            return $this->find_upline($upline->id, $rank_id, ++$up);
        }
    }



    function make_autopool_member($userid)
    {
        $found = $this->db_model->count_all('member_autopool');


        if ($userid > 0) {
            if ($found <= 0) {
                $data = [
                    'autopool' => 0,
                    'userid' => $userid,
                ];
                $this->db->insert('member_autopool', $data);
            } else {

                $pos = $this->autopool_position();
                $position = $pos['position'];
                $leg = $pos['leg'];

                $data = [
                    'autopool' => 0,
                    'userid' => $userid,
                    'position' => $position,
                    'leg' => $leg,
                    'date' => date('Y-m-d H:i:s')
                ];
                $this->db->insert('member_autopool', $data);


                $data = [
                    $leg => $userid,
                ];
                $this->db->where('userid', $position)->update('member_autopool', $data);
            }

            $this->upgrade_autopool_member();
        }



        return true;
    }

    function autopool_position()
    {
        $pos = $this->db->select('id,userid,A,B')->from('member_autopool')->or_where(['A' => 0, 'B' => 0])->get()->row();
        if ($pos->A == 0) {
            $leg = 'A';
        } else {
            $leg = 'B';
        }

        $data = [
            'position' => $pos->userid,
            'leg' => $leg
        ];

        return $data;
    }


    function upgrade_autopool_member()
    {
        $autopool = [
            1 => ['team' => 2, 'autopool_id' => 0, 'upgrade' => 600, "income" => 0],
            2 => ['team' => 4, 'autopool_id' => 1, 'upgrade' => 1200, "income" => 1200],
            3 => ['team' => 8, 'autopool_id' => 2, 'upgrade' => 2400, "income" => 7200],
            4 => ['team' => 16, 'autopool_id' => 3, 'upgrade' => 4800, "income" => 33600],
            5 => ['team' => 32, 'autopool_id' => 4, 'upgrade' => 9600, "income" => 144000],
            6 => ['team' => 64, 'autopool_id' => 5, 'upgrade' => 19200, "income" => 595200],
            7 => ['team' => 128, 'autopool_id' => 6, 'upgrade' => 38400, "income" => 2419200],
            8 => ['team' => 256, 'autopool_id' => 7, 'upgrade' => '-', "income" => 9830400],
        ];

        $member = $this->db->from('member_autopool')->get()->result();


        foreach ($member as $m) {
            $autopool_id = $m->autopool + 1;
            $autopool_data = $autopool[$autopool_id];
            $elig = $this->autopool_eligibility($m->userid, $autopool[$autopool_id]);
            if ($elig) {
                $data = [
                    'autopool' => $autopool_id
                ];
                $this->db->where('userid', $m->userid)->update('member_autopool', $data);

                $autopool_income = $autopool_data['income'];

                if ($autopool_income > 0) {
                    $reciever_wallet_balance = $this->db_model->select('balance', 'wallet', ['userid' => $m->userid]);
                    $new_balance = $reciever_wallet_balance + $autopool_income;
                    $this->db->where('userid', $m->userid)->update('wallet', ['balance' => $new_balance]);

                    $data = [
                        'userid' => $m->userid,
                        'amount' => $autopool_income,
                        'status' => 'CR',
                        'remark' => 'Autopool ' . $autopool_id . 'Income',
                        'date' => date('Y-m-d H:i:s')
                    ];


                    $this->db->insert('wallet_transection_report', $data);

                    $data = [
                        'userid' => $m->userid,
                        'amount' => $autopool_income,
                        'type' => 'Autopool ' . $autopool_id . 'Income',
                        'status' => 'Paid',
                        'ref_id' => 'Autopool ' . $autopool_id . 'Income',
                        'secret' => 12,
                        'date' => date('Y-m-d H:i:s')
                    ];

                    $this->db->insert('earning', $data);
                }
            }
        }

        return true;
    }

    function autopool_eligibility($userid, $autopool)
    {

        $min_team = $autopool['team'];
        $team_autopool = $autopool['autopool_id'];

        $team = $this->db_model->total_downline_autopool('position', $userid, 'userid', 'member_autopool', $team_autopool);

        $flag = 0;
        if (count($team) >= $min_team) {
            $flag = 1;
        } else {
            $flag = 0;
        }

        return $flag;
    }
}
