<?php

/***************************************************************************************************
 * Copyright (c) 2020. by Codepeople India
 * This project is developed and maintained by Codepeople India.
 * Nobody is permitted to modify the source or any part of the project without permission.
 * Project Developer: Bidush Sarkar
 * Developed for: Codepeople India
 **************************************************************************************************/
defined('BASEPATH') or exit('No direct script access allowed');

class News extends CI_Controller
{
    /**
     * Check Valid Login or display login page.
     */
    public function __construct()
    {
        parent::__construct();
        if ($this->login->check_session() == false) {
            redirect(site_url('site/admin'));
        }
        $this->load->library('pagination');
    }

    public function index()
    {
        $data['title']      = 'Dashboard';
        $data['breadcrumb'] = 'dashboard';
        $this->load->view('admin/base', $data);
    }

    public function add_news()
    {

        $this->form_validation->set_rules('description', 'Description', 'trim|required');
        if ($this->form_validation->run() == false) {
            $data['title']      = 'Update News';
            $data['breadcrumb'] = 'Update News';
            $data['layout']     = 'news/create_news.php';
            $this->load->view('admin/base', $data);
        } else {
            $description        = $this->input->post('description');

            $data = array(
                'description'       => $description,
            );
            $this->db->where('id', 1)->update('news', $data);
            $this->session->set_flashdata('common_flash', '<div class="alert alert-success">Update successfully.</div>');
            redirect('news/add_news');
        }
    }
    public function add_popup()
    {

        $this->form_validation->set_rules('description', 'Description', 'trim|required');
        if ($this->form_validation->run() == false) {
            $data['title']      = 'Update Popup';
            $data['breadcrumb'] = 'Update Popup';
            $data['layout']     = 'news/create_popup.php';
            $this->load->view('admin/base', $data);
        } else {
            $this->load->model('Common_model');
            $description        = $this->input->post('description');
             
            $ima=$this->Common_model->upload_image('member', 'image');          
            if($ima['icon']=='error')
            {
                $this->session->set_flashdata('common_flash', '<div class="alert alert-success">'.$ima['text'].'</div>');
                redirect('news/add_popup');
            }

            $image = $ima['text'];
            $imag=$this->db_model->select('image','news',array('id'=>2));
            unlink($imag);

            $data = array(
                'description'       => $description,
                'image'             => $image,
            );           
            $this->db->where('id', 2)->update('news', $data);
            $this->session->set_flashdata('common_flash', '<div class="alert alert-success">Update successfully.</div>');
            redirect('news/add_popup');
        }
       
    }

    function deleted($return)
    {
       
        $image=$this->db_model->select('image','news',array('id'=>2));
        unlink($image);
        $data = array(
            'description' =>'',
            'image'       =>'',
        );          
        $this->db->where('id', 2)->update('news', $data);
        $this->session->set_flashdata('common_flash', '<div class="alert alert-success">Deleted Successfully</div>');
        redirect('news/'.$return);
    }
}