<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Company extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->login->check_session() == false) {
            redirect(site_url('site/admin'));
        }
    }

    function index()
    {

        $this->form_validation->set_rules('name', 'Company Name', 'required');
        if ($this->form_validation->run() == FALSE) {
            $details = $this->db_model->select_multi('*', 'company_setting', ['id' => 1]);



            $data['details'] = $details;
            $data['title']      = 'Comapny ';
            $data['breadcrumb'] = 'Comapny Setting';
            $data['layout']     = 'company/basic.php';
            $this->load->view('admin/base', $data);
        } else {

            $post = $this->input->post();

            $company = $this->db_model->select_multi('*', 'company_setting', ['id' => 1]);

            $logos = $this->db_model->upload_image('member', 'logo');
            $favicons = $this->db_model->upload_image('member', 'favicon');
            if ($logos['icon'] == 1) {
                unlink($company->logo);
                $logo = $logos['text'];
            } else {
                $logo = $company->logo;
            }


            if ($favicons['icon'] == 1) {
                unlink($company->favicon);
                $favicon = $favicons['text'];
            } else {
                $favicon = $company->favicon;
            }


            $data = [
                'name' => $post['name'],
                'address' => $post['address'],
                'phone' => $post['phone'],
                'email' => $post['email'],
                'facebook' => $post['facebook'],
                'youtube' => $post['youtube'],
                'linkedin' => $post['linkedin'],
                'instagram' => $post['instagram'],
                'tweeter' => $post['tweeter'],
                'logo' => $logo,
                'favicon' => $favicon
            ];
            $this->db->where('id', 1)->update('company_setting', $data);
            $this->session->set_flashdata("common_flash", "<div class='alert alert-success'>Update Successfully.</div>");
            redirect(base_url('company'));
        }
    }


    function account_details()
    {
        // echo "hello";
        // die;
        $this->form_validation->set_rules('bank_name', 'Bank Name', 'required');
        if ($this->form_validation->run() == FALSE) {

            $account = $this->db_model->select_all('company_bank_details', '*');
            $data['account'] = $account;
            $data['title']      = 'Comapny Setting';
            $data['breadcrumb'] = 'Comapny Setting';
            $data['layout']     = 'company/bank_info.php';
            $this->load->view('admin/base', $data);
        } else {

            $post = $this->input->post();

            $qr = $this->db_model->upload_image('member', 'qr_code');

            if ($qr['icon'] == 0) {
                $this->session->set_flashdata("common_flash", "<div class='alert alert-danger'>" . $qr['text'] . "</div>");
                redirect(base_url('company/account_details'));
            }
            $qr_code = $qr['text'];


            $data = [
                'qr_code' => $qr_code,
                'upi_address' => $post['upi_address'],
                'bank_name' => $post['bank_name'],
                'account_holder' => $post['account_holder'],
                'acccount_number' => $post['acccount_number'],
                'ifsc_code' => $post['ifsc_code'],
                'bank_branch' => $post['bank_branch'],
                'date' => date('Y-m-d')
            ];

            $this->db->insert('company_bank_details', $data);
            $this->session->set_flashdata("common_flash", "<div class='alert alert-sussess'>Account Information added</div>");
            redirect(base_url('company/account_details'));
        }
    }

    function status($table, $id, $status)
    {
        $status = $status == 0 ? 1 : 0;
        $this->db->where('id', $id)->update($table, ['status' => $status]);
        if ($status == 1) {
            $this->db->where('id!=', $id)->update($table, ['status' => 0]);
        }
        $this->session->set_flashdata("common_flash", "<div class='alert alert-danger'>Status Update</div>");
        redirect(base_url('company/account_details'));
    }
}
