<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($title) ? $title : 'Member List'; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        table, th, td {
            border: 1px solid #000;
            border-collapse: collapse;
            padding: 5px;
        }
        thead {
            background-color: #f0f0f0;
        }
        img {
            width: 50px;
            height: auto;
        }
        @media print {
            table, th, td {
                border: 1px solid black;
                border-collapse: collapse;
                padding: 5px;
                font-size: 14px;
            }

        }
    </style>
</head>
<body onload="window.print()">
    <p style="text-align: center;"><img src="<?php echo base_url('uploads/logo.png')?>" alt="logo"></p>
    <h2 style="text-align: center;"><?php echo config_item('company_name')?></h2>
    <p style="text-align: center;"><?php echo config_item('company_address')?></p>
    <h3>All Member List</h3>

    <table>
        <thead>
            <tr>
                <th>Sn.</th>
                <th>Userid</th>
                <th>Photo</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Rank</th>
               
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($member)): ?>
                <?php foreach ($member as $i => $m): ?>
                <tr>
                    <td><?php echo ++$i; ?></td>
                    <td><?php echo htmlspecialchars(config_item('ID_EXT') . $m->id); ?></td>
                    <td>
                        <img src="<?php echo base_url($m->my_img); ?>" alt="Photo of <?php echo htmlspecialchars($m->name); ?>" onerror="this.style.display='none';">
                    </td>
                    <td><?php echo htmlspecialchars($m->name); ?></td>
                    <td><?php echo htmlspecialchars($m->phone); ?></td>
                    <td><?php echo htmlspecialchars($m->email); ?></td>                   
                    <td><?php echo htmlspecialchars($m->rank); ?></td>                   
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" style="text-align: center;">No members found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
