<?php

/***************************************************************************************************
 * Copyright (c) 2020. by Codepeople India
 * This project is developed and maintained by Codepeople India.
 * Nobody is permitted to modify the source or any part of the project without permission.
 * Project Developer: Bidush Sarkar
 * Developed for: Codepeople India
 **************************************************************************************************/
defined('BASEPATH') or exit('No direct script access allowed');

class Account extends CI_Controller
{
    /**
     * Check Valid Login or display login page.
     */
    public function __construct()
    {
        parent::__construct();
        if ($this->login->check_session() == false) {
            redirect(site_url('site/admin'));
        }
        $this->load->library('pagination');
    }

    public function index()
    {
        $data['acc_info'] = $this->db->select('*')->from('account_details')->get()->result_array();
        $data['title']      = 'Dashboard';
        $data['breadcrumb'] = 'dashboard';
        $data['layout']     = 'account/manage_account.php';
        $this->load->view('admin/base', $data);
    }

    public function account()
    {
        $data['title']      = 'Add Account';
        $data['breadcrumb'] = 'Add Account';
        $data['layout']     = 'account/add_account.php';
        $this->load->view('admin/base', $data);
    }


    
    public function view_details()
    {
        $post = $this->input->post();
        $data['acc_info'] = $this->db->select('*')->from('account_details')->where('id',$post['id'])->get()->row();
        $data['title']      = 'Account Details';
        $data['breadcrumb'] = 'Account Details';
        $this->load->view('admin/account/view_account.php',$data);
    }


    public function get_verify()  // pro_password
    {
       
        $this->form_validation->set_rules('pro_password', 'Password', 'trim|required');

        if ($this->form_validation->run() === false) {
            echo json_encode(array('status' => 'error', 'message' => $this->form_validation->error_array()));
            return;
        }

        $post = $this->input->post();

        $pro_password = $this->db->select('id,profile_password,name')->from('admin')->get()->result_array();
        foreach($pro_password as $p){
          $user_id = $this->db->select('id,profile_password')->from('admin')->where('id',$p['id'])->get()->row();
        }

         if($post['pro_password'] == $user_id->profile_password){
            // echo "Match password";
            $data = ['status' => 'success', 'message' => 'Successfully.', 'actReload' => base_url('account')];
         }else{
            // echo "Not Match password";
            $data = ['status' => 'error', 'message' => 'Invalid Password', 'actReload' => base_url('admin')];
         }

        echo json_encode($data);
    }


    

    public function add_account()
    {

        $this->form_validation->set_rules('hname', 'Holder Name', 'trim|required');
        $this->form_validation->set_rules('bname', 'Bank Name', 'trim|required');

        if ($this->form_validation->run() === false) {
            echo json_encode(array('status' => 'error', 'message' => $this->form_validation->error_array()));
            return;
        }

        $post = $this->input->post();

        $lastId = $this->db->select('id, userid')->from('account_details')->order_by('id', 'DESC')->limit(1)->get()->row();

        if (!empty($lastId) && !empty($lastId->userid) && $lastId->userid !== '0') {
            $lastNumber = (int)substr($lastId->userid, 3);
            $lastKHY = 'AID' . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            $lastKHY = 'AID1001';
        }

        $qr_code = $this->upload_image('account_details', 'qr_code');

        $qr_code_img = ($qr_code['icon'] == 'success') ? $qr_code['text'] : '';

        $value = array(

            'userid'        => $lastKHY,  
            'qr_code'       => $qr_code_img,
            'holder_name'   => $post['hname'],
            'bank_name'     => $post['bname'],
            'acc_number'    => $post['accnumber'],
            'ifsc_code'     => $post['ifsccode'],
            'branch_name'   => $post['braName'],
            'upi_number'    => $post['upi_number'],
            'upi_id'        => $post['upi_id'],
            'date'          => date('Y-m-d'),
            'created_at'          => date('Y-m-d'),
        );

        $save = $this->db->insert('account_details', $value);

        if ($save) {
        $data = ['status' => 'success', 'message' => 'Thank you! Data added successfully.', 'actReload' => base_url('account')];
        } else {
        $data = ['status' => 'error', 'message' => 'Something went wrong. Please try again.', 'actReload' => base_url('account')];
        }

        echo json_encode($data);

    }

    function upload_image($path, $name)
    {
        $config['upload_path']          = './uploads/' . $path;
        $config['allowed_types']        = 'jpg|png|jpeg';
        $config['max_size']             = 2048;
        // $config['max_width']            = 1024;
        // $config['max_height']           = 768;

        $this->load->library('upload', $config);

        if ($this->upload->do_upload($name)) {
            $upload_data =  $this->upload->data();
            $image_path = "uploads/" . $path . '/' . $upload_data['file_name'];


            $a = array('photo' => $image_path);
            $this->session->set_userdata($a);


            $val = array('text' => $image_path, 'icon' => 'success');
        } else {
            $val = array('text' => $this->upload->display_errors(), 'icon' => 'error');
        }

        return $val;
    }


     public function actPstatus($id)
    {
        $table = $this->input->post('table');
        $getValue = $this->db->select('id, status')->from($table)->where('id', $id)->get()->row();
        if (!empty($getValue)) {
            if ($getValue->status == '0') {
                $this->db->where('id', $id)->update($table, ['status' => '1']);
                $data = ['status' => 'success', 'message' => 'Thank you! Now active.'];
            } elseif ($getValue->status == '1') {
                $this->db->where('id', $id)->update($table, ['status' => '0']);
                $data = ['status' => 'error', 'message' => 'Thank you! Now inactive.'];
            }
        } else {
            $data = ['status' => 'error', 'message' => 'Something went wrong. Please try again later.'];
        }
        echo json_encode($data);
    }


}
