<?php

/***************************************************************************************************
 * Copyright (c) 2020. by Camwel Corporate Solution PVT LTD
 * This project is developed and maintained by Camwel Corporate Solution PVT LTD.
 * Nobody is permitted to modify the source or any part of the project without permission.
 * Project Developer: Bidush Sarkar
 * Developed for: Camwel Corporate Solution PVT LTD
 **************************************************************************************************/
?>
<h3 class="text-center"><span class="text-success">Wallet Balance : <?php echo config_item('currency') . number_format($wallet_ballance,2); ?></span></h3>
<p>
    <a href="javascript:void(0);" id="add" data-toggle="modal" data-target="#add_fund" class="btn btn-danger" style="float: right;"><span class="fa fa-Plus"></span>Add Fund</a>
</p>
<br>
<br>
<div class="table-responsive">
    <table id="example" class="table text-white">
        <thead class="bg-primary text-nowrap">
            <tr>
                <th>SN</th>
                <th>Amount</th>
                <th>Tr. Id</th>
                <th>Status</th>
                <th>Request Date</th>
                <th>Remark</th>
                <th>Approval Date</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sn = 1;
            foreach ($request as $e) { ?>
                <tr>
                    <td><?php echo $sn++; ?></td>
                    <td><?php echo $e->amount; ?></td>
                    <td><?php echo $e->transection_id; ?></td>
                    <td><?php echo $e->status; ?></td>
                    <td><?php echo $e->created_at; ?></td>
                    <td><?php echo ($e->remark) ? $e->remark : 'NA' ?></td>
                    <td><?php echo ($e->varified_at) ? $e->varified_at : 'NA'; ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
<div class="pull-right">
    <?php echo $this->pagination->create_links(); ?>
</div>


<!-- model start -->


<div class="modal fade" id="add_fund" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title text-center" id="exampleModalLabel">Add Fund Now</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <h3 class="text-center"><span class="text-success">Wallet Balance : <?php echo config_item('currency') . $wallet_ballance; ?></span></h3>
                <form id="add_fund_form" method="post" action="<?php echo base_url() . "member/requestaddfund" ?>" enctype="multipart/form-data">
                    <div class="row ">
                        <div class="col-sm-12 text-center">
                            <img src="<?php echo base_url() . $company_account->qr_code; ?>" alt="" style="max-width:100%;height:100px">
                        </div>
                        <div class="col-sm-12">
                            <label>Amount<span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter Amount" required>
                        </div>
                        <div class="col-sm-12">
                            <label>Transaction Id<span class="text-danger">*</span></label>
                            <input type="text" value="" class="form-control" id="tid" name="tid" placeholder="Enter Transaction Id" required>
                        </div>

                        <div class="col-sm-12">
                            <label>Screenshot<span class="text-danger">*</span></label>
                            <input type="file" value="" class="form-control" id="img" name="img" placeholder="Enter Screenshots Id" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-danger">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- model end -->